window.KommoWidget = window.KommoWidget || {};

define([
  "./classes/template.js",
  "./classes/loader.js",
  "./classes/kommo.js",
  "./classes/events.js",
  "./classes/settings.js",
  "./plugins/jquery.serializejson.min.js",
], function (Templates, Loader, Kommo, Events, Settings) {
  return function () {
    let _this = this;

    _this.config = {
      code: "kommo_metrics",
      prefix: "kommo-metrics",
      templates: {
        params: {
          settings: [
            { id: "loader", path: "/loader" },
            { id: "settings.base", path: "/settings/base" },
            { id: "settings.dashboard", path: "/settings/dashboard" }
          ]
        }
      },
      css: [
        { name: "kommo", append_id: "kommo-common-style" },
        { name: "style" }
      ],
      icons: {}
    };

    _this.info = {};

    _this.getNested = function (obj, desc, value) {
      let arr = desc ? desc.split(".") : [];
      while (arr.length && obj) {
        let comp = arr.shift();
        let match = /(.+)\[([0-9]*)\]/.exec(comp);
        if (match !== null && match.length == 3) {
          let arrayData = { arrName: match[1], arrIndex: match[2] };
          if (typeof obj[arrayData.arrName] !== "undefined") {
            obj = obj[arrayData.arrName][arrayData.arrIndex];
          } else {
            obj = null;
          }
          continue;
        }
        obj = obj[comp];
      }
      if (typeof value !== "undefined") {
        if (obj === null || typeof obj === "undefined" || obj === undefined) {
          return value;
        }
      }
      return obj;
    };

    _this.validateSettings = function (params) {
      return true;
    };

    _this.callbacks = {
      dpSettings: function () {},
      bind_actions: function () { return true; },

      render: function () {
        _this.config.icons = { path: _this.params.path + "/images" };
        _this.debug = console;
        _this.kommo = new Kommo(_this);
        _this.templates = new Templates(_this);
        _this.loader = new Loader(_this);
        _this.events = new Events(_this);
        _this.settings = new Settings(_this);

        return APP.widgets.system.area === "settings" || APP.widgets.system.area === "advanced-settings"
          ? true
          : _this.templates.preload().then(() => true);
      },

      settings: function () {
        let status = (_this.params || {}).status || "";
        let activeStatuses = ["not_configured", "installed"]; // widget installed but not necessarily configured
        let isActive = status.length > 0 && $.inArray(status, activeStatuses) >= 0;

        let modalBlock = $(".modal." + _this.params.widget_code);
        let wrapDiv = modalBlock.find(".widget_settings_block");

        _this.templates.preload().then(function () {
          if (isActive) {
            wrapDiv.find(".widget_settings_block__controls").hide();
            wrapDiv.find(".widget_settings_block__descr").hide();
            _this.loader.prepend(wrapDiv);

            _this.settings
              .load(modalBlock)
              .then(function () {
                return Promise.all([
                  _this.kommo.getPipelines(),
                  _this.kommo.getFields("leads"),
                  _this.kommo.getUsers()
                ]);
              })
              .then(function ([pipelines, fields, users]) {
                _this.info.params = _this.info.params || {};

                // map pipelines to select items
                let pipelinesSelect = (pipelines || []).map(function (p) {
                  return { id: p.id, option: p.name };
                });

                // collect statuses by pipeline
                let statusesByPipeline = {};
                (pipelines || []).forEach(function (p) {
                  statusesByPipeline[p.id] = (p.statuses || []).map(function (s) {
                    return { id: s.id, option: s.name };
                  });
                });

                // Fields dropdown (campaign)
                let fieldsSelect = (fields || []).map(function (f) {
                  return { id: f.id, option: f.name };
                });

                wrapDiv.prepend(
                  _this.templates.render("settings.base", {
                    prefix: _this.config.prefix,
                    langs: _this.i18n("settings"),
                    icons: _this.config.icons,
                    version: _this.params.version,
                    active: true,
                    selects: {
                      pipeline: _this.templates.twig.select({
                        block: "filters",
                        code: "pipeline_id",
                        items: pipelinesSelect,
                        selected: _this.getNested(_this.info.params, "filters.pipeline_id", "")
                      }),
                      status: _this.templates.twig.select({
                        block: "filters",
                        code: "status_id",
                        items: statusesByPipeline[_this.getNested(_this.info.params, "filters.pipeline_id", 0)] || [],
                        selected: _this.getNested(_this.info.params, "filters.status_id", "")
                      }),
                      date_range: _this.templates.twig.select({
                        block: "filters",
                        code: "date_range",
                        items: [
                          { id: "7", option: _this.i18n("settings.filters.date_range_7") },
                          { id: "30", option: _this.i18n("settings.filters.date_range_30") },
                          { id: "90", option: _this.i18n("settings.filters.date_range_90") }
                        ],
                        selected: _this.getNested(_this.info.params, "filters.date_range", "30")
                      }),
                      campaign_field: _this.templates.twig.select({
                        block: "mapping",
                        code: "campaign_field_id",
                        items: fieldsSelect,
                        selected: _this.getNested(_this.info.params, "mapping.campaign_field_id", "")
                      })
                    },
                    channels: {
                      fb_ads: _this.templates.twig.input({ block: "mapping", code: "fb_ads", placeholder: "facebook,fb,meta" , value: _this.getNested(_this.info.params, "mapping.fb_ads", "") }),
                      ig_ads: _this.templates.twig.input({ block: "mapping", code: "ig_ads", placeholder: "instagram,ig" , value: _this.getNested(_this.info.params, "mapping.ig_ads", "") }),
                      web: _this.templates.twig.input({ block: "mapping", code: "web", placeholder: "web,site" , value: _this.getNested(_this.info.params, "mapping.web", "") }),
                      organic: _this.templates.twig.input({ block: "mapping", code: "organic", placeholder: "organic,seo" , value: _this.getNested(_this.info.params, "mapping.organic", "") }),
                      direct: _this.templates.twig.input({ block: "mapping", code: "direct", placeholder: "direct" , value: _this.getNested(_this.info.params, "mapping.direct", "") })
                    },
                    whatsapp: _this.templates.twig.input({ block: "mapping", code: "whatsapp_tag", placeholder: "whatsapp,wa", value: _this.getNested(_this.info.params, "mapping.whatsapp_tag", "whatsapp") }),
                    actions: {
                      calculate: _this.templates.twig.button({ block: "actions", code: "calculate", text: _this.i18n("settings.actions.calculate") }),
                      export_csv: _this.templates.twig.button({ block: "actions", code: "export_csv", text: _this.i18n("settings.actions.export_csv") })
                    }
                  })
                );

                _this.info._statusesByPipeline = statusesByPipeline;

                _this.events.settings();
                $("#kommo-settings").fadeIn(300);
                _this.loader.displaySaveBtn(_this.params.widget_code);
                return _this.loader.hide();
              })
              .catch(function (ex) {
                _this.debug.error(ex);
              });
          }

          if (!isActive) {
            return _this.templates.installPlaceholder(wrapDiv);
          }
        });

        return true;
      },

      init: function () { return true; },
      onSave: function (evt) { return _this.settings.save(evt); },
      destroy: function () {},
      contacts: { selected: function () {} },
      leads: { selected: function () {} }
    };

    return this;
  };
});
