define(["jquery", "lib/components/base/modal", "twigjs", "text"], function (
  $,
  Modal,
  twig,
  text
) {
  return class Templates {
    constructor(widget) {
      this.widget = widget;
      this.templates = widget.config.templates || {};
      this.templates.html = {};
      this.css = widget.config.css;
      this.textSavedXhr = text.useXhr;
    }

    flushTextPlugin() {
      text.useXhr = function () {
        return true;
      };
    }

    restoreTextPlugin() {
      text.useXhr = this.textSavedXhr;
    }

    checkRegistry(name) {
      let id = "kommo_mt_" + name;
      return !!(Twig.Templates || {}).registry[id];
    }

    getFromRegistry(name) {
      let id = "kommo_mt_" + name;
      return (Twig.Templates || {}).registry[id] || "";
    }

    preload() {
      return Promise.all([this.loadCss(), this.loadTemplates()]);
    }

    loadTemplates() {
      let _this = this;
      return new Promise(function (resolve) {
        let area = APP.widgets.system.area;
        let templates = _this.templates.params[area] || [];
        _this.flushTextPlugin();
        if (templates.length > 0) {
          let load = [];
          let ids = [];
          templates.forEach(function (template) {
            if (template.id.indexOf(_this.widget.config.code) === -1) {
              template.id = _this.widget.config.code + "_" + template.id;
            }

            if (!template.url) {
              template.url =
                _this.widget.params.path +
                "/assets/templates" +
                template.path +
                ".twig?v=" +
                _this.widget.get_version();
            }

            if (!_this.checkRegistry(template.id)) {
              load.push("text!" + template.url);
              ids.push(template.id);
            } else {
              _this.templates.html[template.id] = _this.getFromRegistry(
                template.id
              );
            }
          });

          if (load.length > 0) {
            require(load, function () {
              for (let i = 0; i < arguments.length; i++) {
                _this.addTemplate(ids[i], arguments[i]);
              }
              resolve();
            });
          } else {
            resolve();
          }
        } else {
          resolve();
        }
      });
    }

    addTemplate(name, data) {
      let id = "kommo_mt_" + name;
      if (this.checkRegistry(name)) {
        this.templates.html[name] = Twig.Templates.registry[id];
        return;
      }

      this.templates.html[name] = twig({
        id: id,
        data: data,
        allowInlineIncludes: true,
      });
    }

    loadCss() {
      let _this = this;
      return new Promise(function (resolve) {
        let html = "";
        _this.css.forEach((file) => {
          let $style = null;
          let path =
            _this.widget.params.path +
            "/assets/css/" +
            file.name +
            ".css?v=" +
            _this.widget.params.version;
          if (file.append_id) {
            $style = $("#" + file.append_id);
          } else {
            $style = $('link[href="' + path + '"]');
          }

          if ($style.length < 1) {
            html += '<link type="text/css" rel="stylesheet" href="' + path + '"';
            if (file.append_id) {
              html += ' id="' + file.append_id + '"';
            }
            html += ">";
          }
        });

        if (html.length > 0) {
          $("head").append(html);
        }

        resolve();
      });
    }

    render(name, params) {
      name = this.widget.config.code + "_" + name;
      return this.templates.html[name].render(params || {});
    }

    installPlaceholder(wrapDiv, exception = null) {
      let params = {
        prefix: this.widget.config.prefix,
        langs: this.widget.i18n("settings"),
        active: false,
      };

      if (exception !== null) {
        params.exception = exception;
      }

      wrapDiv.prepend(this.render("settings.base", params));
      $("#kommo-settings").fadeIn(300);
      this.widget.loader.displaySaveBtn(this.widget.params.widget_code);
      return this.widget.loader.hide();
    }

    get twig() {
      let _this = this;
      let prefix = _this.widget.config.prefix;
      return {
        modal: (html, destroyCallback = function () {}, className = "") => {
          return new Modal({
            class_name: prefix + "-modal-window " + className + " ",
            init: function ($modal) {
              $modal
                .trigger("modal:loaded")
                .html(html)
                .trigger("modal:centrify");
            },
            destroy: destroyCallback,
          });
        },
        dropdown: (params) => {
          let block = params.block || "";
          let code = params.code || "";
          let defaultParams = $.extend(
            {
              items: [],
              class_name: prefix + "__" + block + "-" + code + " ",
              id: prefix + "-" + block + "-" + code + "-id",
              name: "params[" + block + "][" + code + "]",
              name_is_array: false,
            },
            params
          );

          return _this.widget.render(
            { ref: "/tmpl/controls/checkboxes_dropdown/values_title.twig" },
            defaultParams
          );
        },
        select: (params) => {
          let block = params.block || "";
          let code = params.code || "";
          let defaultParams = $.extend(
            {
              items: [],
              class_name: prefix + "__" + block + "-" + code + " ",
              id: prefix + "-" + block + "-" + code + "-id",
              name: "params[" + block + "][" + code + "]",
            },
            params
          );

          return _this.widget.render(
            { ref: "/tmpl/controls/select.twig" },
            defaultParams
          );
        },
        input: (params) => {
          let block = params.block || "";
          let code = params.code || "";
          let defaultParams = $.extend(
            {
              id: prefix + "-" + block + "-" + code + "-id",
              class_name: prefix + "__" + block + "-" + code + " ",
              name: "params[" + block + "][" + code + "]",
              value: "",
              type: "text",
              placeholder: "",
            },
            params
          );

          return _this.widget.render(
            { ref: "/tmpl/controls/input.twig" },
            defaultParams
          );
        },
        textarea: (params) => {
          let block = params.block || "";
          let code = params.code || "";
          let defaultParams = $.extend(
            {
              id: prefix + "-" + block + "-" + code + "-id",
              class_name: prefix + "__" + block + "-" + code + " ",
              name: "params[" + block + "][" + code + "]",
              value: "",
              placeholder: "",
            },
            params
          );

          return _this.widget.render(
            { ref: "/tmpl/controls/textarea.twig" },
            defaultParams
          );
        },
        button: (params) => {
          let block = params.block || "";
          let code = params.code || "";
          let defaultParams = $.extend(
            {
              class_name: prefix + "__" + block + "-" + code + " ",
              id: prefix + "-" + block + "-" + code + "-id",
              name: "params[" + block + "][" + code + "]",
              text: "",
            },
            params
          );

          return _this.widget.render(
            { ref: "/tmpl/controls/button.twig" },
            defaultParams
          );
        },
      };
    }
  };
});
