define([], function () {
  return class Settings {
    constructor(widget) {
      this.widget = widget;
    }

    save(evt) {
      let _this = this;
      let code = _this.widget.params.widget_code;
      let isActive = false;
      let paramsSelector = "#" + _this.widget.config.prefix + "-settings__form";
      let params = ($(paramsSelector).serializeJSON() || {}).params || {};

      return new Promise(function (resolve, reject) {
        isActive = evt.active === "Y";
        let data = { is_active: isActive };

        let installed = ((_this.widget.params || {}).active || "N") === "Y";
        if (!installed) {
          resolve({ reinstall: true });
        }

        if (isActive) {
          if (!_this.widget.validateSettings(params)) {
            $(".modal." + code)
              .find(".js-widget-save")
              .trigger("button:save:error");
            reject();
          } else {
            data.params = params;
          }
        }

        _this.widget.info = data;
        evt.fields.custom = JSON.stringify(params);
        resolve(data);
      }).then(function () { return true; });
    }

    load() {
      let _this = this;
      return new Promise((resolve) => {
        _this.widget.info.params = (_this.widget.params || {}).custom || {};
        if (typeof _this.widget.info.params === "string") {
          try { _this.widget.info.params = JSON.parse(_this.widget.info.params); } catch (e) { _this.widget.info.params = {}; }
        }
        resolve([]);
      });
    }
  };
});
