define([], function () {
  return class Loader {
    constructor(widget) {
      let _this = this;
      _this.templates = widget.templates;
      _this.langs = widget.langs;
      _this.html = "";
      _this.widget = widget;
    }

    prepend(elem) {
      elem.prepend(this.getHtml());
      return this;
    }

    append(elem) {
      elem.append(this.getHtml());
      return this;
    }

    getHtml() {
      let _this = this;
      if (_this.html.length === 0) {
        _this.html = _this.templates.render("loader", {
          widget: _this.langs.widget.name,
          icons: _this.widget.config.icons,
        });
      }
      return _this.html;
    }

    hide() {
      return $(".kommo-loader").hide();
    }

    show() {
      $(".kommo-loader").show();
      return this;
    }

    remove() {
      $(".kommo-loader").remove();
      return this;
    }

    displaySaveBtn(code) {
      $(".modal." + code)
        .find(".widget_settings_block__controls")
        .show();
      return this;
    }
  };
});
