define(["./http.js"], function (Http) {
  return class Kommo {
    constructor(widget) {
      this.http = new Http();
      this.widget = widget;
    }

    getPipelines() {
      return this.http
        .request(
          "/api/v4/leads/pipelines",
          { with: "statuses", page: 1, limit: 250 },
          "GET",
          { baseURL: window.location.origin }
        )
        .then(function (data) {
          let pipelines = ((data || {})._embedded || {}).pipelines || [];
          return pipelines.map(function (p) {
            let statuses = [];
            // statuses may be in p._embedded.statuses or p.statuses
            let rawStatuses = ((p || {})._embedded || {}).statuses || p.statuses || {};
            if (Array.isArray(rawStatuses)) {
              statuses = rawStatuses.map(function (s) {
                return { id: s.id, name: s.name };
              });
            } else {
              statuses = Object.values(rawStatuses).map(function (s) {
                return { id: s.id, name: s.name };
              });
            }
            return { id: p.id, name: p.name, statuses: statuses };
          });
        });
    }

    getFields(et, page = 1, fields = []) {
      let _this = this;
      return _this.http
        .request(
          "/api/v4/" + et + "/custom_fields",
          { page: page },
          "GET",
          { baseURL: window.location.origin }
        )
        .then(function (data) {
          let cf = ((data || {})._embedded || {}).custom_fields || [];
          if (cf.length === 0) {
            return fields;
          }
          fields = fields.concat(cf);
          if (((data || {})._page_count || 0) > 1 && (data._page || 1) < data._page_count) {
            return _this.getFields(et, page + 1, fields);
          } else {
            return fields;
          }
        });
    }

    getUsers(users = [], page = 1) {
      let _this = this;
      return this.http
        .request(
          "/api/v4/users",
          { limit: 100, page: page },
          "GET",
          { baseURL: window.location.origin }
        )
        .then(function (data) {
          return new Promise((resolve) => {
            let tmp = ((data || {})._embedded || {}).users || [];
            tmp.forEach(function (user) {
              if ((user.rights || {}).is_active) {
                users.push({
                  id: user.id,
                  option: user.name,
                  name: user.name,
                  is_admin: (user.rights || {}).is_admin,
                });
              }
            });
            if (data._page_count > 1 && data._page < data._page_count) {
              resolve(_this.getUsers(users, page + 1));
            } else {
              resolve(users);
            }
          });
        });
    }

    listLeads(params = {}, page = 1, leads = []) {
      let _this = this;
      let payload = { limit: 250, page: page, with: "tags", filter: {} };

      // created_at filter
      if (params.from || params.to) {
        payload.filter.created_at = {};
        if (params.from) payload.filter.created_at.from = params.from;
        if (params.to) payload.filter.created_at.to = params.to;
      }

      // statuses filter array
      if (params.pipeline_id || params.status_id) {
        let statusFilter = {};
        if (params.pipeline_id) statusFilter.pipeline_id = params.pipeline_id;
        if (params.status_id) statusFilter.status_id = params.status_id;
        payload.filter.statuses = [statusFilter];
      }

      return _this.http
        .request("/api/v4/leads", payload, "GET", { baseURL: window.location.origin })
        .then(function (data) {
          let items = ((data || {})._embedded || {}).leads || [];
          leads = leads.concat(items);
          if (((data || {})._page_count || 0) > 1 && (data._page || 1) < data._page_count) {
            return _this.listLeads(params, page + 1, leads);
          } else {
            return leads;
          }
        });
    }

    getCFValue(lead, fieldId) {
      let cfv = (((lead || {}).custom_fields_values) || []).find(function (f) {
        return String(f.field_id) === String(fieldId);
      });
      if (!cfv) return "";
      let v = (((cfv || {}).values || [])[0] || {}).value;
      if (typeof v === "string") return v;
      if (v && typeof v === "object" && v.hasOwnProperty("value")) return String(v.value);
      return String(v || "");
    }
  };
});
