define(["./cache.js"], function (Cache) {
  return class Http {
    constructor() {}
    request(type, payload, method, options = {}) {
      let cache = new Cache();
      return new Promise(function (resolve, reject) {
        let data = null;
        if (options.cache) {
          data = cache.getItem(options.cache.key);
        }
        if (!data) {
          $.ajax({
            url: (options.baseURL || "") + type,
            data: payload,
            method: method,
            beforeSend: function (xhr) {
              xhr.withCredentials = true;
            },
            headers: options.headers || {},
          })
            .done(function (data) {
              resolve(data);
            })
            .fail(function (resp) {
              reject(resp);
            });
        } else {
          resolve(data);
        }
      }).then(function (data) {
        return new Promise(function (resolve) {
          if (options.embedded && (data || {})["_embedded"]) {
            data = (data || {})["_embedded"][options.embedded] || [];
          }
          if (options.cache && data) {
            cache.setItem(
              options.cache.key,
              data,
              options.cache.expires,
              options.cache.local || false
            );
          }
          if (options.rk) {
            data = (data || {})[options.rk] || null;
          }
          resolve(data);
        });
      });
    }
  };
});
