define([], function () {
  return class Cache {
    constructor() {
      window.KommoWidget.cache = window.KommoWidget.cache || {};
    }

    getItem(key) {
      let result;
      if (window.KommoWidget.cache[key]) {
        result = window.KommoWidget.cache[key];
      } else {
        let cache = JSON.parse(window.sessionStorage.getItem(key) || null);
        if (cache !== null && cache.expires <= Math.floor(Date.now() / 1000)) {
          window.sessionStorage.removeItem(key);
        }
        result = (cache || {}).payload || null;
      }
      return result;
    }

    setItem(key, value, expires, local) {
      if (local) {
        window.KommoWidget.cache[key] = value;
      } else {
        window.sessionStorage.setItem(
          key,
          JSON.stringify({ payload: value, expires: Math.floor(Date.now() / 1000) + expires })
        );
      }
    }

    removeItem(key) {
      window.sessionStorage.removeItem(key);
    }
  };
});
